/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Flt floats[8];

struct CustomData
{
   Byte bytes[100];
   Flt  real;
   Int  integer;
}data[8];

Memb<CustomData> memb;
/******************************************************************************

   Custom comparing functions must be of "Int name(TYPE &a,TYPE &b)" format
   they receive references to 2 custom data elements
   they must return:
   -1 if 'a' should be before 'b'
   +1 if 'a' should be after  'b'
    0 if 'a' is the same as   'b'

/******************************************************************************/
Int CompareCustomData(CustomData &a,CustomData &b)
{
   if(a.real<b.real)return -1;
   if(a.real>b.real)return +1;
                    return  0;
}
/******************************************************************************/
void InitPre()
{
   App.name="Sorting";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   REPA(floats)floats[i]     =RndF(10); // fill 'floats'    with random values (0..10)
   REPA(data  )data  [i].real=RndF(10); // fill 'data.real' with random values (0..10)
   REP (8     )memb  (i).real=RndF(10); // fill 'memb.real' with random values (0..10)

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   if(Kb.bp(KB_SPACE)) // sort when space pressed
   {
      Sort(floats,ELMS(floats)                  ); // sort 'floats'
      Sort(data  ,ELMS(data  ),CompareCustomData); // sort custom data by giving pointer to data, number of elements and custom comparing function
      Sort(memb               ,CompareCustomData); // sort custom data by giving memory block                        and custom comparing function
   }

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   D.text (0,0.7,"Press Space to sort");
   
   Str s="floats:  "; FREPA(floats){s+=floats[i]     ; s+="  ";} D.text(0, 0.2,s); // draw 'floats'    in one string
       s="data:  "  ; FREPA(data  ){s+=data  [i].real; s+="  ";} D.text(0, 0.0,s); // draw 'data.real' in one string
       s="memb:  "  ; FREPA(memb  ){s+=memb  [i].real; s+="  ";} D.text(0,-0.2,s); // draw 'memb.real' in one string
}
/******************************************************************************/
